tic;
clear;
pvar x1 x2 x3 x4 x5 J J_rho J_tau;
%%% Load system parameters here. %%%
load parameters_disc_3D.mat;
load noise_parameters.mat;

%%% Change weight matrix here. %%%
Z=diag([1 40 1 1 20]);

%%% Input highest degree in pitch and travel system here. %%%
high_degree_rho=4; % highest degree in pitch system
high_degree_tau=4; % highest degree in travel system


x_rho=[x1;x2;x3];
n=length(x_rho);
A=Rho_disc.a;
B=Rho_disc.b;
C=Rho_disc.c;
X=P_rho;
W=Q_rho;
V=R_rho;
L=L_rho;
lambda_rho=0.1;
Q=(eye(n)-L*C)*X;
Y=L*(C*A*Q*A'*C'+C*W*C'+V)*L';
thereshold=5e-3;

% Calculate the expected value function of monomials in the polynomial
s(1,:)=ones(1,max(high_degree_rho,high_degree_tau));
for j=1:max(high_degree_rho,high_degree_tau)
    s(2,j)=j+1;
    if n>3
        error('Have not figured out the rule for producing monomials with higher than 3 order');
    else if n==3
        s(3,j)=(j+1)*(j+2)/2;
        end
    end
end
 
[moment_rho cm_rho]=one_step_expect_monomials(high_degree_rho,x_rho,A,Y);

% get rid of the minus term in moment_rho
array_num=length(moment_rho);
for j=1:array_num
    term_num=length(moment_rho(1,j).coefficient);
    jj=1;
    while jj<=term_num
        if abs(moment_rho(1,j).coefficient(jj,1))<thereshold && sum(moment_rho(1,j).degmat(jj,:))>0
            moment_rho(1,j).coefficient(jj,1)=0;
            term_num=term_num-1;
        else
            jj=jj+1;
        end
    end
end
% save moment_data_rho.mat moment_rho cm_rho;       

x_tau=[x4;x5];
n=length(x_tau);
A=Tau_disc.a;
B=Tau_disc.b;
C=Tau_disc.c;
X=P_tau;
W=Q_tau;
V=R_tau;
L=L_tau;
lambda_tau=0.1;
Q=(eye(n)-L*C)*X;
Y=L*(C*A*Q*A'*C'+C*W*C'+V)*L';

[moment_tau cm_tau]=one_step_expect_monomials(high_degree_tau,x_tau,A,Y);

% get rid of the minus term in moment_rho
array_num=length(moment_tau);
for j=1:array_num
    term_num=length(moment_tau(1,j).coefficient);
    jj=1;
    while jj<=term_num
        if abs(moment_tau(1,j).coefficient(jj,1))<thereshold && sum(moment_tau(1,j).degmat(jj,:))>0
            moment_tau(1,j).coefficient(jj,1)=0;
            term_num=term_num-1;
        else
            jj=jj+1;
        end
    end
end
toc


%%% SOS algorithm here. %%%
lambda=0.1;
tic
x=[x_rho;x_tau];
% initialization
prog=sosprogram(x);
% define variable. Here,we use a polynomial without cross terms between
% x_rho and x_tau.
[prog,f_rho]=sospolyvar(prog,monomials(x_rho,2:2:high_degree_rho),'wscoeff');
[prog,f_tau]=sospolyvar(prog,monomials(x_tau,2:2:high_degree_tau),'wscoeff');
% define inequalities
term_num=length(f_rho.coefficient);
E_f_rho=0;
E_f_0_rho=0;
n=length(x_rho);
for i=1:term_num
    coefficient_tend=polynomial(1,[f_rho.degmat(i,1:term_num) zeros(1,n)],f_rho.varname,[1 1]);
    pos_tend=position(f_rho.degmat(i,term_num+1:term_num+n),s);
    row_tend=ceil(pos_tend/57);
    E_f_rho=E_f_rho+coefficient_tend*moment_rho(row_tend,pos_tend-57*(row_tend-1));
    E_f_0_rho=E_f_0_rho+coefficient_tend*cm_rho(pos_tend);
end
term_num=length(f_tau.coefficient);
E_f_tau=0;
E_f_0_tau=0;
n=length(x_tau);
for i=1:term_num
    coefficient_tend=polynomial(1,[f_tau.degmat(i,1:term_num) zeros(1,n)],f_tau.varname,[1 1]);
    pos_tend=position(f_tau.degmat(i,term_num+1:term_num+n),s);
    row_tend=ceil(pos_tend/57);
    E_f_tau=E_f_tau+coefficient_tend*moment_tau(row_tend,pos_tend-57*(row_tend-1));
    E_f_0_tau=E_f_0_tau+coefficient_tend*cm_tau(pos_tend);
end
prog=sosdecvar(prog,J);
% constraints
c1=lambda*0.25;
c2=lambda*0.25;
c=lambda*0.6;
deg_inc=2;
deg_dif1=1;
deg_dif2=1;
step_inv1=x.^(deg_inc-deg_dif1)'*Z*x.^(deg_inc-deg_dif1)/c1;
step_inv2=x.^(deg_inc+deg_dif2)'*Z*x.^(deg_inc+deg_dif2)/c2;
step_inv=x.^(deg_inc)'*Z*x.^(deg_inc)/c;
d=0.5;
cs1=(step_inv1+1)*(J+f_rho+f_tau-(E_f_rho+E_f_tau+x'*Z*x))+(E_f_rho+E_f_tau+x'*Z*x)*(step_inv-d);
cs2=(step_inv2+1)*(J+f_rho+f_tau-(E_f_0_rho+E_f_0_tau+lambda))+(E_f_0_rho+E_f_0_tau+lambda)*(d-step_inv);
prog=sosineq(prog,cs1);
prog=sosineq(prog,cs2);
prog=sosineq(prog,J);
prog=sossetobj(prog,J);

% call solver
[prog,info]=sossolve(prog);
% get solution
Js=sosgetsol(prog,J)+0.0012+ 2.6412e-005
fs_rho=sosgetsol(prog,f_rho);
fs_tau=sosgetsol(prog,f_tau);

% Compute polynomial event trigger
Ef0=0;
Ef=0;
for i=1:term_num
    coefficient_tend=polynomial(1,[f_tau.degmat(i,1:term_num) zeros(1,n)],f_tau.varname,[1 1]);
    c_t=sosgetsol(prog,coefficient_tend);
    pos_tend=position(f_tau.degmat(i,term_num+1:term_num+n),s);
    row_tend=ceil(pos_tend/57);
    Ef=Ef+c_t*moment_tau(row_tend,pos_tend-57*(row_tend-1));
    Ef0=Ef0+c_t*cm_tau(pos_tend);
end
term_num=length(f_rho.coefficient);
n=length(x_rho);
for i=1:term_num
    coefficient_tend=polynomial(1,[f_rho.degmat(i,1:term_num) zeros(1,n)],f_rho.varname,[1 1]);
    c_t=sosgetsol(prog,coefficient_tend);
    pos_tend=position(f_rho.degmat(i,term_num+1:term_num+n),s);
    row_tend=ceil(pos_tend/57);
    Ef=Ef+c_t*moment_rho(row_tend,pos_tend-57*(row_tend-1));
    Ef0=Ef0+c_t*cm_rho(pos_tend);
end
toc
poly_event_trigger=Ef-Ef0+x'*Z*x-lambda